#version 140
#extension GL_EXT_gpu_shader4 : enable
// Complex exponentiation map colorMod01.fsh  by ale93111

//https://www.shadertoy.com/view/XsKSWm
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Alessandro Marzo - ale93111/2016
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// same as my other shader: https://www.shadertoy.com/view/ldVXD1 
// but with different methods of coloring taken from:
// iq - https://www.shadertoy.com/view/4dfGRn
// gtoledo3 - https://www.shadertoy.com/view/Xt2SDw

//supersampling
#define  AA 2

const int max_iterations = 10;

float izoom = 1.0/3.0; //increase denominator to increase zoom
vec2 ioffset = vec2( 0.0, -0.11); //offset to center the picture
vec3 color = vec3(0.0);  //RGB

//Complex Exponentiation - Source: http://mathworld.wolfram.com/ComplexExponentiation.html
vec2 powC( vec2 Z, vec2 W)
{
    float arg = atan(Z.y / Z.x);
    //press mouse to remove scale animation
    //float a = exp( -W.y*arg )*pow( dot(Z,Z), W.x/(3.0 + ((iMouse.w>0.0)? -1.0 :cos(0.2*iTime)))); 
    float a = exp( -W.y*arg )*pow( dot(Z,Z), W.x/4.0 ); //wihtout scaling animation
    float b = W.x*arg + 0.5*W.y*log( dot(Z,Z) );
    
    return a*vec2(cos(b), sin(b));    
} 
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    for( int jj=0; jj<AA; jj++ )
    for( int ii=0; ii<AA; ii++ )  
	{
        vec2 p = (((gl_FragCoord.yx - iResolution.xy*0.3 + vec2(float(ii),float(jj))/float(AA)) / iResolution.x) * izoom) + ioffset;
        vec2 Z = (((gl_FragCoord.yx - iResolution.xy*0.3 + vec2(float(ii),float(jj))/float(AA)) / iResolution.x) * izoom) + ioffset;
    
		vec3 col = vec3(0.0);
    
    	float k = 1.0-abs(cos(0.2*iTime));
    	//float k = 1.0; //wihtout exponentiation animation
        //float k = 1.6180339887;
    	vec4 dmin = vec4(1000.0);
        
   		for(int i=0; i<max_iterations; i++) 
    	{
      
        	// Z^Z^Z...20-21 times animated between odd and even exponentiation
        	Z = powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,k*powC(Z,powC(Z,powC(Z,Z))))))))))))))))))));
        
        	// Z^Z^Z...64-65 times animated between odd and even exponentiation
        	//Z = powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,powC(Z,k*powC(Z,Z))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))))));
        
            dmin=min(dmin, vec4(abs(0.0+Z.y + 0.5*sin(Z.x)), 
								abs(1.0+Z.x + 0.5*sin(Z.y)), 
								dot(Z,Z),
							    length( fract(Z)-0.5) ) );
            
        	if( dot(Z,Z)> 0.1) break;
    	}
    
        vec3 color1 = vec3( dmin.w );
		

		color1 = color1*color1*color1*color1;
	
		//color *= 0.5 + 0.5*pow(abs(16.0*p.x*(1.0-p.x)*p.y*(1.0-p.y)),0.15);
        
    	
        col = vec3(smoothstep( 0.0, sqrt(3.0), float(sqrt(abs(dot(Z,Z))))),
                   smoothstep( 0.0, sqrt(50.0), float(sqrt(abs(dot(Z,Z))))),
                   smoothstep( 0.0, sqrt(5e20), float(sqrt(abs(dot(Z,Z))))));
        
        Z.x+=sin(Z.y*2.);
		Z.y+=sin(Z.x*20.)*.1;
		Z.x+=sin(Z.y*3.);
		Z.y+=sin(Z.x*5.);
	
		float rand = mod(fract(sin(dot(2.5*p,vec2(12.9898,100.233+iTime)))*43758.5453),.35);
		float v = 0.4; 
        float depthCull=0.1;
		vec3 col2;
        float shade=0.1;
  
		v +=sin(Z.x*20.0) *0.01;
		v +=sin(Z.y*120.0)*0.02;
		v +=sin(Z.y*20.0) *0.01; 
		v +=sin(Z.x*4.0)  *0.2;
		v +=sin(Z.x*7.0)  *0.2;
		v=clamp(v,0.0,1.0);
		col2 = vec3((rand*.75)+vec3(pow(v+0.2,-0.95)))*vec3(0.4, 0.2, 0.2);
        
        col = mix( col, vec3(0.00,0.20,0.40), 1.0-min(1.0,pow(dmin.x*0.25,0.50)) );
   	 	col = mix( col, vec3(0.72,0.20,0.20), 1.0-min(1.0,pow(dmin.y*0.50,0.30)) );
		col = mix( col, vec3(0.70,0.20,0.20), 1.0-min(1.0,pow(dmin.z*1.00,0.35) ));
        
        color += col*col2*col; 
    }
    color /= float(AA*AA);
	gl_FragColor = vec4( color, 1.0);
}




